/**
* Script: gamehud.js
* Written by: Radnen
* Updated: 2/4/2011
**/

var GameHud = ({
	selPlanet: null,
	help_msg: "",
	highlight_name: "",
	highlight_status: "",
	showChart: false,
	showMinimap: false,
	hudColor: CreateColor(0, 0, 80, 80),
	range: 10,
	
	setPlanet: function(planet) {
		this.selPlanet = planet;
		this.highlight_name = planet.name;
		this.highlight_status = "-"+planet.status+"-";
	},

	unsetPlanet: function() {
		this.selPlanet = null;
		this.highlight_name = "";
		this.highlight_status = "";
	},
	
	updateHighlight: function() {
		if (this.selPlanet != null) {
			if (GetDist(Genesis.player.ship.x, Genesis.player.ship.y, this.selPlanet.x, this.selPlanet.y) > 800) this.unsetPlanet();
		}
	},

	renderBraces: function() {
		if (this.selPlanet != null) {
			this.drawBraces(this.selPlanet);
		}
		
		if (Genesis.player.ship.target != null) {
			this.drawBraces(Genesis.player.ship.target);
			Genesis.player.ship.target.drawRating();
		}
	},
	
	// used to draw the braces around a selected target //
	drawBraces: function(obj) {
		Resources.images.ul_brace.blit(obj.xx         , obj.yy         );
		Resources.images.ur_brace.blit(obj.xx+obj.w-16, obj.yy         );
		Resources.images.dr_brace.blit(obj.xx+obj.w-16, obj.yy+obj.h-16);
		Resources.images.dl_brace.blit(obj.xx         , obj.yy+obj.h-16);
	},
	
	drawStatusBar: function(text, x, y, stat, col1, col2) {
		var w = SW/6, h = 20;
		var delta = stat.value/stat.max*(w-4);
		
		GradientRectangle(
			x-w/2, y, w, h,
			Colors.darkGray, Colors.darkGray,
			Colors.black, Colors.black
		);
		
		OutlinedRectangle(
			x-w/2, y,
			w, h,
			Colors.darkGray, 1
		);

		if (stat.max > 0) {
			GradientRectangle(
				x-w/2+2,  y+2,
				delta, h-4,
				col1, col1,
				col2, col2
			);
		}

		System.windowFont.drawText(x-w/2+4, y+2, text);
	},
	
	drawEquipSlot: function(x, y, eq) {
		Rectangle(x, y, 24, 24, Colors.black);
		OutlinedRectangle(x, y, 24, 24, Colors.darkGray);
		if (eq.item > -2) {
			OutlinedRectangle(x, y, 24, 24, Colors.white);
		}
		if (eq.item > -1) {
			Resources.images[Items[eq.item].image].blit(x+4, y+4);
			if (eq.amount > 0) System.windowFont.drawText(x+6, y+10, "x"+eq.amount);
		}
	},
	
	drawGUI: function() {
		this.help_msg = "";
		Resources.images.testoverlay.blit(0, 0);
		this.drawStatusBar("Armor", SW/2, SH-88, Genesis.player.ship.hp, Colors.green, Colors.darkGreen);
		this.drawStatusBar("Fuel", SW/2, SH-64, Genesis.player.ship.jumps, Colors.purple, Colors.darkPurple);
		this.drawStatusBar("Battery", SW/2, SH-40, Genesis.player.ship.shields, Colors.blue, Colors.darkBlue);
		this.drawEquipSlot(SW/2-SW/12-26, SH-77, Genesis.player.ship.equips.left);
		this.drawEquipSlot(SW/2-SW/12-26, SH-51, Genesis.player.ship.equips.right);
		this.drawEquipSlot(SW/2+SW/12+2, SH-77, Genesis.player.ship.equips.secondary);
		this.drawEquipSlot(SW/2+SW/12+2, SH-51, Genesis.player.ship.equips.tech);
		Rectangle(0, 0, 180, 68, this.hudColor);
		OutlinedRectangle(0, 0, 180, 68, Colors.darkGray);
		System.textFont.drawText(4, 4, "Cred: " + Genesis.player.credits);
		System.textFont.drawText(4, 24, "Capacity: " + Genesis.player.ship.cap.value + "/" + Genesis.player.ship.cap.max);
		System.textFont.drawText(4, 44, "Escorts: " + Genesis.player.ship.escort.value + "/" + Genesis.player.ship.escort.max);
		
		var w = System.textFont.getStringWidth(this.currentWorld + " System")-4;
		Rectangle(SW-w-4, 0, w, 24, this.hudColor);
		OutlinedRectangle(SW-w-4, 0, w, 24, Colors.darkGray);
		System.textFont.drawText(SW-w, 4, Genesis.currentWorld + " System");
		
		if (this.showChart) StarChart.drawChart(0, SH-StarChart.h);
		else if (StarChart.selectedSystem != null) System.textFont.drawText(4, SH-18, "Targeted System: " + StarChart.selectedSystem.name);
		if (this.showMinimap) this.drawMinimap();
		
		if (this.selPlanet != null) {			
			var x = this.selPlanet.x;
			var y = this.selPlanet.y;
			if (Genesis.player.ship.cx > x && Genesis.player.ship.cy > y && Genesis.player.ship.cx < x+this.selPlanet.w && Genesis.player.ship.cy < y+this.selPlanet.h) {
				if (this.selPlanet.canLand && Genesis.player.ship.speed < 1.5) this.help_msg = "Press L to Land on this Planet.";
				if (IsKeyPressed(KEY_L)) {
					Genesis.save("Autosave");
					Genesis.player.updateQuestDays();
					var l_state = new LandState(this.selPlanet);
					l_state.show();
				}
			}
		}
		
		System.textFont.drawText(SW/2-System.textFont.getStringWidth(this.highlight_name)/2, 4, this.highlight_name);
		System.textFont.drawText(SW/2-System.textFont.getStringWidth(this.highlight_status)/2, 20, this.highlight_status);
		System.textFont.drawText(SW-System.textFont.getStringWidth(this.help_msg)-4, SH-20, this.help_msg);
	},

	drawMinimap: function() {
		var w = SW/3, h = SH/3;
		var mx = SW-w, my = SH-h, i = 0, ship, planet, text = "";
		Rectangle(mx, my, w, h, this.hudColor);
		OutlinedRectangle(mx, my, w, h, Colors.darkGray);
		SetClippingRectangle(mx, my, w, h);
		System.windowFont.drawText(mx+2, my+2, "Zoom: x" + this.range + "/1");
		mx = SW-w/2, my = SH-h/2;
		
		i = Genesis.planets.length;
		while(i--) {
			planet = Planets[Genesis.planets[i]];
			var x = mx+(planet.x+(planet.w>>1)-Genesis.player.ship.x)/this.range;
			var y = my+(planet.y+(planet.h>>1)-Genesis.player.ship.y)/this.range;
			var r = planet.w/(this.range<<1);
			OutlinedCircle(x, y, r, Colors.gray);
			if (Cursor.isWithin(x-r, y-r, r<<1, r<<1)) text = planet.name;
		}
		
		i = Genesis.ships.length;
		while(i--) {
			ship = Genesis.ships[i];
			var x = mx+(ship.cx-Genesis.player.ship.x)/this.range;
			var y = my+(ship.cy-Genesis.player.ship.y)/this.range;
			if (ship.ai_status == AI_COMBAT)
				Resources.images.playerblip.rotateBlitMask(x, y, ship.a.radians, Colors.red);
			else if (ship.ai_status == AI_FLEE)
				Resources.images.playerblip.rotateBlitMask(x, y, ship.a.radians, Colors.blue);
			else
				Resources.images.playerblip.rotateBlit(x, y, ship.a.radians);
			if (Cursor.isWithin(x, y, 16, 16)) text = ship.name;
		}
		
		i = Genesis.bullets.length;
		while(i--) {
			bullet = Genesis.bullets[i];
			Point(mx+(bullet.x-Genesis.player.ship.x)/this.range, my+(bullet.y-Genesis.player.ship.y)/this.range, Colors.gray);
		}
		
		Resources.images.playerblip.rotateBlitMask(mx, my, Genesis.player.ship.a.radians, Colors.yellow);
		System.windowFont.drawText(Cursor.x+6, Cursor.y+8, text);
		SetClippingRectangle(0, 0, SW, SH);
	},
})